<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/19
 * @website https://swiftotter.com
 **/

namespace Chapter1\CLI\Controller\Index;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\State as AppState;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Store\Model\App\Emulation;

class Index implements HttpGetActionInterface
{
    /** @var RawFactory */
    private RawFactory $rawFactory;
    private AppState $state;
    private EventManager $eventManager;
    private Emulation $emulation;

    public function __construct(
        RawFactory $rawFactory,
        AppState $state,
        EventManager $eventManager,
        Emulation $emulation
    ) {
        $this->rawFactory = $rawFactory;
        $this->state = $state;
        $this->eventManager = $eventManager;
        $this->emulation = $emulation;
    }

    public function execute()
    {
        /** @var Raw $output */
        $output = $this->rawFactory->create();

        $this->emulation->startEnvironmentEmulation(0, 'adminhtml', true);
        $this->eventManager->dispatch('sample_event');
        $this->emulation->stopEnvironmentEmulation();

        $details = '';

        $output->setContents($details);

        return $output;
    }
}
