<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/19
 * @website https://swiftotter.com
 **/

namespace Chapter1\ExtraTesting\Controller\ObjectManager;

use Chapter1\CustomConfig\Model\Config;
use Chapter1\CustomConfig\Model\ConfigFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Module\Dir;
use Symfony\Component\CssSelector\CssSelectorConverter;

class ExternalClasses implements HttpGetActionInterface
{
    private RawFactory $rawFactory;
    private CssSelectorConverter $converter;

    public function __construct(
        RawFactory $rawFactory,
        CssSelectorConverter $cssSelectorConverter
    ) {
        $this->rawFactory = $rawFactory;
        $this->converter = $cssSelectorConverter;
    }

    public function execute()
    {
        /** @var Raw $output */
        $output = $this->rawFactory->create();

        $details = $this->converter->toXPath('div.item > h4 > a');
        $reflection = new \ReflectionClass($this->converter);
        $property = $reflection->getProperty('translator');

        $property->setAccessible(true);

        /** @var \Symfony\Component\CssSelector\XPath\Translator $value */
        $value = $property->getValue($this->converter);

        try {
            $htmlExtension = $value->getExtension('html');

            if ($htmlExtension) {
                $extension = 'HTML present (GOOD)';
            } else {
                throw new \Exception();
            }
        } catch (\Throwable $ex) {
            $extension = 'No HTML (BAD)';
        }

        $output->setContents($details . '<br/>' . $extension);

        return $output;
    }
}
