<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/19
 * @website https://swiftotter.com
 **/

namespace Chapter1\Plugins\Controller\Example1;

use Chapter1\CustomConfig\Model\Config;
use Chapter1\CustomConfig\Model\ConfigFactory;
use Chapter1\Plugins\Model\MyModel;
use Chapter1\Plugins\Model\MyModelFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Module\Dir;

class Index implements HttpGetActionInterface
{
    private RawFactory $rawFactory;
    private MyModelFactory $myModelFactory;

    public function __construct(
        RawFactory $rawFactory,
        MyModelFactory $myModel
    ) {
        $this->rawFactory = $rawFactory;
        $this->myModelFactory = $myModel;
    }

    public function execute()
    {
        /** @var Raw $output */
        $output = $this->rawFactory->create();

        $result = $this->myModelFactory->create()->get('Elissa', []);
        $executionOrder = implode('', array_map(function($item) {
            return '<li>' . $item . '</li>';
        }, $result['log']));

        $details = <<<OUTPUT
<h2>Output:</h2>
<p>Result: {$result['statement']}</p>
<h4>Details:</h4>
<ul>
{$executionOrder}
</ul>
OUTPUT;

        $output->setContents($details);

        return $output;
    }
}
