<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/25
 * @website https://swiftotter.com
 **/

namespace Chapter2\Layout\Controller\Index;

use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

class AddBlock implements HttpGetActionInterface
{
    private PageFactory $pageFactory;

    public function __construct(PageFactory $pageFactory)
    {
        $this->pageFactory = $pageFactory;
    }

    public function execute()
    {
        $output = $this->pageFactory->create();
        $layout = $output->getLayout();

        $layout->getBlock('product.price.render.default'); // forcing $layout->build();

        $newBlock = $layout->addBlock(Template::class, 'my.block1', 'content');
        $newBlock->setTemplate('Chapter2_Layout::new-block.phtml');

        return $output;
    }
}
