<?php
declare(strict_types=1);

namespace Chapter2\UiDemonstration\Controller\Adminhtml\Index;

use Magento\Backend\App\Action as BackendAction;
use Magento\Backend\Model\View\Result\ForwardFactory;
use Magento\Backend\Model\View\Result\RedirectFactory;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\App\CsrfAwareActionInterface;
use Magento\Framework\View\Result\PageFactory;

/**
 * @by SwiftOtter, Inc. 8/19/20
 * @website https://swiftotter.com
 **/

class Create extends BackendAction implements HttpGetActionInterface
{
    /** @var RedirectFactory */
    private $redirectFactory;

    public function __construct(
        Context $context,
        RedirectFactory $redirectFactory
    ) {
        $this->redirectFactory = $redirectFactory;

        parent::__construct($context);
    }

    public function execute()
    {
        $forward = $this->redirectFactory->create();
        $forward->setPath('*/*/edit');

        return $forward;
    }
}