<?php
declare(strict_types=1);

namespace Chapter3\Database\Setup\Patch\Data;

use Chapter3\Database\Tables;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class InitializeDiscounts implements DataPatchInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;

    public function __construct(ModuleDataSetupInterface $moduleDataSetup)
    {
        $this->moduleDataSetup = $moduleDataSetup;
    }

    public function apply()
    {
        $this->moduleDataSetup->getConnection()->insert(Tables::DISCOUNT, [
            'name' => '$10 off',
            'amount' => 10
        ]);

        $this->moduleDataSetup->getConnection()->insert(Tables::DISCOUNT, [
            'name' => '$20 off',
            'amount' => 20
        ]);

        $this->moduleDataSetup->getConnection()->insert(Tables::DISCOUNT, [
            'name' => '$30 off',
            'amount' => 30
        ]);
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }
}
