<?php
declare(strict_types=1);

namespace Chapter3\SetupScripts\Setup\Patch\Data;

use Chapter3\SetupScripts\Attributes;
use Chapter3\SetupScripts\Model\Source\MetalTypes as MetalTypesSource;
use Magento\Catalog\Model\Product as ProductModel;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class CreateMetalTypeAttribute implements DataPatchInterface
{
    /** @var ModuleDataSetupInterface */
    private $moduleDataSetup;

    /** @var EavSetupFactory */
    private $eavSetupFactory;

    public function __construct(ModuleDataSetupInterface $moduleDataSetup, EavSetupFactory $eavSetupFactory)
    {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create();
        $eavSetup->addAttribute(
            ProductModel::ENTITY,
            Attributes::METAL_TYPE,
            [
                'group' => 'General',
                'type' => 'varchar',
                'label' => 'Metal Type',
                'input' => 'select',
                'option' => ['Test 1', 'Test 2'],
                'source' => MetalTypesSource::class,
                'required' => false,
                'sort_order' => 50,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_GLOBAL,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'visible' => true,
                'is_html_allowed_on_front' => true,
                'visible_on_front' => true
            ]
        );
    }

    public function getAliases()
    {
        return [];
    }

    public static function getDependencies()
    {
        return [];
    }
}
