<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/19
 * @website https://swiftotter.com
 **/

namespace Chapter3\Staging\Controller\Adminhtml\Example2;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Registry;
use Magento\Framework\View\Result\Page;
use Magento\Framework\View\Result\PageFactory;

class Index implements HttpGetActionInterface
{
    private Registry $registry;

    private ProductRepositoryInterface $productRepository;
    private PageFactory $pageFactory;

    public function __construct(
        Registry $registry,
        ProductRepositoryInterface $productRepository,
        PageFactory $pageFactory
    ){
        $this->registry = $registry;
        $this->productRepository = $productRepository;
        $this->pageFactory = $pageFactory;
    }

    public function execute()
    {
        $product = $this->productRepository->getById(1429);
        $this->registry->register('current_product', $product);

        return $this->pageFactory->create();
    }
}
