<?php
declare(strict_types=1);

namespace Chapter4\EAV\Setup\Patch\Data;

use Chapter4\EAV\Attributes;
use Magento\Catalog\Model\Category as CategoryModel;
use Magento\Customer\Api\AddressMetadataInterface;
use Magento\Customer\Model\Customer;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Model\Entity\Attribute\Source\Boolean;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Magento\Customer\Model\ResourceModel\Attribute as CustomerAttributeResource;
use Magento\Sales\Model\Order;
use Magento\Sales\Setup\SalesSetup;

class CreateCategoryAttribute implements DataPatchInterface, PatchVersionInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    /**
     * Adapted from:
     * https://www.mageplaza.com/magento-2-module-development/magento-2-add-customer-attribute-programmatically.html
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create();
        $eavSetup->addAttribute(CategoryModel::ENTITY, Attributes::CATEGORY_SHOW_HEADER, [
            'type'     => 'int',
            'label'    => 'Show Header',
            'input'    => 'boolean',
            'source'   => Boolean::class,
            'visible'  => true,
            'default'  => '0',
            'required' => false,
            'global'   => ScopedAttributeInterface::SCOPE_STORE,
            'group'    => 'Display Settings',
        ]);
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    public static function getVersion()
    {
        return "4";
    }
}
