<?php
declare(strict_types=1);

namespace Chapter4\EAV\Setup\Patch\Data;

use Chapter4\EAV\Attributes;
use Magento\Customer\Api\AddressMetadataInterface;
use Magento\Customer\Model\Customer;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Magento\Customer\Model\ResourceModel\Attribute as CustomerAttributeResource;
use Magento\Sales\Model\Order;
use Magento\Sales\Setup\SalesSetup;

class CreateOrderAttribute implements DataPatchInterface, PatchVersionInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;
    private EavConfig $eavConfig;
    private CustomerAttributeResource $customerAttributeResource;
    private SalesSetup $salesSetup;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory,
        SalesSetup $salesSetup
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->salesSetup = $salesSetup;
    }

    /**
     * Adapted from:
     * https://www.mageplaza.com/magento-2-module-development/magento-2-add-customer-attribute-programmatically.html
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function apply()
    {
        $this->salesSetup->addAttribute(Order::ENTITY, 'is_important', [
            'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
            'length'=> 255,
            'visible' => false,
            'nullable' => true
        ]);

        $this->salesSetup->getConnection()->addColumn(
            $this->salesSetup->getTable('sales_order_grid'),
            'is_important',
            [
                'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                'length' => 255,
                'comment' =>'Is Important'
            ]
        );
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    public static function getVersion()
    {
        return "3";
    }
}
