<?php
declare(strict_types=1);

namespace Chapter4\EAV\Setup\Patch\Data;

use Chapter4\EAV\Attributes;
use Magento\Customer\Model\Customer;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
use Magento\Customer\Model\ResourceModel\Attribute as CustomerAttributeResource;

class CreatePreferredWidgetType implements DataPatchInterface, PatchVersionInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;
    private EavConfig $eavConfig;
    private CustomerAttributeResource $customerAttributeResource;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory,
        EavConfig $eavConfig,
        CustomerAttributeResource $customerAttributeResource
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
        $this->eavConfig = $eavConfig;
        $this->customerAttributeResource = $customerAttributeResource;
    }

    /**
     * Adapted from:
     * https://www.mageplaza.com/magento-2-module-development/magento-2-add-customer-attribute-programmatically.html
     *
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function apply()
    {
        /** @var EavSetup $eavSetup */
        $eavSetup = $this->eavSetupFactory->create();

        // #1 create attribute
        $eavSetup->addAttribute(
            Customer::ENTITY,
            Attributes::CUSTOMER_PREFERRED_WIDGET_TYPE,
            [
                'group'        => 'General',
                'type'         => 'varchar',
                'label'        => 'Preferred Widget Type',
                'input'        => 'text',
                'required'     => false,
                'visible'      => true,
                'user_defined' => true,
                'position'     => 1,
                'system'       => 0,
            ]
        );

        $widgetType = $this->eavConfig->getAttribute(
            Customer::ENTITY,
            Attributes::CUSTOMER_PREFERRED_WIDGET_TYPE
        );

        // #2 add to forms
        $widgetType->setData('used_in_forms', ['adminhtml_customer']);

        // #3 save
        $this->customerAttributeResource->save($widgetType);
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    public static function getVersion()
    {
        return "1";
    }
}
