<?php
declare(strict_types=1);

namespace Chapter4\EAV\Setup\Patch\Data;

use Chapter4\EAV\Attributes;
use Magento\Eav\Setup\EavSetup;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;

class CreateWidgetTypeAttribute implements DataPatchInterface, PatchVersionInterface
{
    private ModuleDataSetupInterface $moduleDataSetup;
    private EavSetupFactory $eavSetupFactory;

    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        EavSetupFactory $eavSetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->eavSetupFactory = $eavSetupFactory;
    }

    public function apply()
    {
        $eavSetup = $this->eavSetupFactory->create();

        // \/ drop a breakpoint here \/ to observe the attribute creation process.
        $eavSetup->addAttribute(
            \Magento\Catalog\Model\Product::ENTITY,
            Attributes::PRODUCT_WIDGET_TYPE,
            [
                'group' => 'General', // note that this automatically creates an attribute group.
                'type' => 'varchar',
                'label' => 'Widget type',
                'input' => 'select',
                'source' => \Chapter4\EAV\Model\Source\WidgetTypes::class,
                'frontend' => \Chapter4\EAV\Model\Frontend\WidgetTypes::class,
                'backend' => \Chapter4\EAV\Model\Backend\WidgetTypes::class,
                'required' => false,
                'sort_order' => 50,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_WEBSITE,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'visible' => true,
                'is_html_allowed_on_front' => true,
                'visible_on_front' => true
            ]
        );
    }

    /**
     * @inheritdoc
     */
    public function getAliases()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public static function getDependencies()
    {
        return [];
    }

    public static function getVersion()
    {
        return "1";
    }
}
