<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/02/12
 * @website https://swiftotter.com
 **/

namespace Chapter5\ACL\Endpoint;

use Chapter5\ACL\Api\AclInterface;
use Chapter5\ACL\Api\Data\AclResponseInterface;
use Chapter5\ACL\Api\Data\AclResponseInterfaceFactory as AclResponseFactory;
use Chapter5\ACL\Api\Data\AclResponseExtensionInterfaceFactory as AclResponseExtensionFactory;

class Acl implements AclInterface
{
    /** @var AclResponseFactory */
    private $aclResponseFactory;

    /** @var AclResponseExtensionFactory */
    private $aclExtensionFactory;

    public function __construct(
        AclResponseFactory $aclResponseFactory,
        AclResponseExtensionFactory $aclExtensionFactory
    ) {
        $this->aclResponseFactory = $aclResponseFactory;
        $this->aclExtensionFactory = $aclExtensionFactory;
    }

    public function sayHello(): AclResponseInterface
    {
        $response = $this->aclResponseFactory->create();
        $response->setMessage('Hello, Joseph');

        $attributes = $response->getExtensionAttributes()
            ?: $this->aclExtensionFactory->create();

        $attributes->setAllowed("This is allowed.");
        $attributes->setRestricted("This is restricted.");

        $response->setExtensionAttributes($attributes);

        return $response;
    }
}
