<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/01/19
 * @website https://swiftotter.com
 **/

namespace Chapter5\BackendCustomization\Controller\Adminhtml\Index;

use Magento\Backend\Model\View\Result\RedirectFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\HttpGetActionInterface;

class Save implements HttpGetActionInterface
{
    /** @var RedirectFactory */
    private $redirectFactory;

    public function __construct(
        RedirectFactory $redirectFactory
    ) {
        $this->redirectFactory = $redirectFactory;
    }

    public function execute()
    {
        $redirect = $this->redirectFactory->create();
        $redirect->setPath('chapter5backendcustomization/index/index');

        return $redirect;
    }
}
