<?php
declare(strict_types=1);
/**
 * @by SwiftOtter, Inc., 2019/02/25
 * @website https://swiftotter.com
 **/

namespace Chapter7\FreeGift\Plugin;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Catalog\Model\Product as ProductModel;
use Magento\Catalog\Model\Product\Type\AbstractType;
use Magento\Directory\Block\Data;
use Magento\Framework\DataObject;
use Magento\Quote\Model\Quote as QuoteModel;

class AddFreeGiftToCart
{
    private $productRepository;

    public function __construct(
        ProductRepositoryInterface $productRepository
    ) {
        $this->productRepository = $productRepository;
    }

    public function afterAddProduct(
        QuoteModel $quote,
        $result,
        ProductModel $product,
        $request = null,
        $processMode = AbstractType::PROCESS_MODE_FULL
    ) {
        if (isset($request['free_product'])) {
            return $result;
        }

        $freeProduct = $quote->addProduct(
            $this->productRepository->get('24-MG04'),
            new DataObject(['free_product' => true, 'qty' => 1])
        );
        $freeProduct->addOption(['is_free' => true]);
        $freeProduct->setCustomPrice(0);
        $freeProduct->setOriginalCustomPrice(0);

        return $result;
    }
}
