<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\AdvanceUrl\Controller\Adminhtml\Index;

use Extendware\AdvanceUrl\Model\AdvanceUrlFactory;
use Magento\Backend\App\Action;

class Save extends \Magento\Backend\App\Action
{
    protected $advanceUrlModel;

    public function __construct(
        Action\Context $context,
        AdvanceUrlFactory $advanceUrlModel
    ) {
        parent::__construct($context);
        $this->advanceUrlModel = $advanceUrlModel;
    }

    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $resultRedirect = $this->resultRedirectFactory->create();

        if ($data) {
            $id = $this->getRequest()->getParam('id');

            $advanceUrlModel = $this->advanceUrlModel->create();
            if ($id) {
                $advanceUrlModel->load($id);
            }

            try {
                $advanceUrlModel->setData($data);
                $advanceUrlModel->save();
                $this->messageManager->addSuccess(__('The data has been saved.'));
                if ($this->getRequest()->getParam('back')) {
                    if ($this->getRequest()->getParam('back') == 'add') {
                        return $resultRedirect->setPath('*/*/add');
                    }

                    return $resultRedirect->setPath(
                        '*/*/edit',
                        [
                            'id' => $advanceUrlModel->getId(),
                            '_current' => true,
                        ]
                    );
                }

                return $resultRedirect->setPath('*/*/');
            } catch (\Magento\Framework\Exception\LocalizedException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\RuntimeException $e) {
                $this->messageManager->addError($e->getMessage());
            } catch (\Exception $e) {
                $this->messageManager->addException($e, __('Something went wrong while saving the data.'));
            }

            return $resultRedirect->setPath('*/*/edit', ['id' => $this->getRequest()->getParam('id')]);
        }

        return $resultRedirect->setPath('*/*/');
    }
}
