<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\AdvanceUrl\Cron;

use Extendware\AdvanceUrl\Helper\Data;
use Extendware\AdvanceUrl\Logger\Logger;
use Extendware\AdvanceUrl\Model\CleanUrlsProcess;

class CleanUrls
{
    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var CleanUrlsProcess
     */
    protected $cleanUrlsProcess;

    /**
     * Constructor
     *
     * @param Logger $logger
     * @param Data $advanceUrlHelper
     */
    public function __construct(
        Logger $logger,
        CleanUrlsProcess $cleanUrlsProcess
    ) {
        $this->logger = $logger;
        $this->cleanUrlsProcess = $cleanUrlsProcess;
    }

    /**
     * Execute the cron job to clean URLs
     *
     * @return void|bool
     */
    public function execute()
    {
        $this->cleanUrlsProcess->processProductUrls();
    }
}
