<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\AdvanceUrl\Model;

use Extendware\AdvanceUrl\Helper\Data;
use Extendware\AdvanceUrl\Logger\Logger;
use Magento\Framework\App\ResourceConnection;

class CleanUrlsProcess
{
    public const DEFAULT_PROFILE = 'None';

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * @var Data
     */
    protected $advanceUrlHelper;

    /**
     * @var AdapterInterface
     */
    protected $connection;

    /**
     * @var ResourceConnection
     */
    protected $resource;

    /**
     * Constructor
     *
     * @param Logger $logger
     * @param Data $advanceUrlHelper
     * @param ResourceConnection $resource
     */
    public function __construct(
        Logger $logger,
        Data $advanceUrlHelper,
        ResourceConnection $resource
    ) {
        $this->logger = $logger;
        $this->advanceUrlHelper = $advanceUrlHelper;
        $this->resource = $resource;
        $this->connection = $resource->getConnection(ResourceConnection::DEFAULT_CONNECTION);
    }

    /**
     * Execute the process clean products urls
     *
     * @return void|bool
     */
    public function processProductUrls($profileName = self::DEFAULT_PROFILE)
    {
        // Check Module Status
        if(!$this->advanceUrlHelper->getModuleStatus()){
            return false;
        }

        // Check and update product url
        $checkProducts = $this->advanceUrlHelper->getAdvanceUrlData()->getCollection();
        $checkProducts->addFieldToFilter('manage_url_status', ['in' => [Data::URL_PENDING]]);
        foreach ($checkProducts as $product) {
            try {
                // Check Product Url
                if($product->getProductUrlkey()){
                    $urlStatus = $this->advanceUrlHelper->updateProductUrl($product);
                    $message = $urlStatus[Data::MESSAGE_CODE] ? $urlStatus[Data::MESSAGE_CODE] : '';
                    if ((isset($urlStatus[Data::STATUS_CODE])) && ($urlStatus[Data::STATUS_CODE])) {
                        $product->setManageUrlStatus(Data::URL_UPDATED);
                    } else {
                        $product->setManageUrlStatus(Data::URL_FAILED);
                    }
                    $product->setMessage($message);
                } else {
                    $product->setManageUrlStatus(Data::URL_FAILED);
                    $product->setMessage("Product URL is invalid");
                }

                $this->connection->insertOnDuplicate(
                    $this->connection->getTableName(Data::EXTENDWARE_ADVANCE_URL_MAIN_TABLE),
                    [
                        'id' => $product->getId(),
                        'manage_url_status' => $product->getManageUrlStatus(),
                        'message' => $product->getMessage(),
                        'profile_name' => $profileName
                    ]
                );
            } catch (\Exception $e) {
                $this->logger->critical('processProductUrls() Function foor loop Issue : ' . $e->getMessage());
            }
        }

        $this->advanceUrlHelper->closeResourceConnection();
        $this->connection->closeConnection();
    }
}
