<?php
/*
 * web-vision GmbH
 * Do not edit or add to this file if you wish to upgrade Magento to newer
 * versions in the future. If you wish to customize Magento for your
 * needs please refer to https://www.web-vision.de for more information.
 * @category    Extendware
 * @copyright   Copyright (c) 2001-2022 web-vision GmbH (https://www.web-vision.de)
 * @author      Mahesh Makwana <mmakwana@web-vision.de>
 */
namespace Extendware\AdvanceUrl\Model\Config\Source;

use Extendware\AdvanceUrl\Helper\Data as AdvanceUrlHelper;

class AdvanceUrlStatus implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * Status for Type
     *
     * @return array
     */
    public function toOptionArray()
    {
        return [
            [
                'value' => AdvanceUrlHelper::URL_PENDING,
                'label' => __('Pending'),
            ],
            [
                'value' => AdvanceUrlHelper::URL_UPDATED,
                'label' => __('Success'),
            ],
            [
                'value' => AdvanceUrlHelper::URL_FAILED,
                'label' => __('Failed'),
            ],
            [
                'value' => AdvanceUrlHelper::URL_QUEUE,
                'label' => __('Queued'),
            ],
        ];
    }
}
