<?php
/**
 * @category  Extendware
 *
 * @copyright 2020 Extendware
 */
declare(strict_types=1);
namespace Extendware\AskQuestion\Controller\Adminhtml\Question;

class Save extends \Magento\Backend\App\Action
{
    const ADMIN_RESOURCE = 'Index';

    protected $resultPageFactory = false;

    protected $questionFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Extendware\AskQuestion\Model\QuestionFactory $questionFactory
    ) {
        $this->resultPageFactory = $resultPageFactory;
        $this->_questionFactory = $questionFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $data = $this->getRequest()->getPostValue();
        $data = $data['reply'];
        if ($data['answer']) {
            $id = $data['id'];

            try {
                $data = array_filter($data, function ($value) {
                    return $value !== '';
                });

                $question = $this->_questionFactory->create()->load($id);
                $question->setAnswer($data['answer']);
                $question->save();
                $question->sendEmail();
                $this->messageManager->addSuccess(__('Successfully saved the item.'));
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData(false);
                $this->_redirect('*/*/listquestions');

                return;
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                $this->_objectManager->get('Magento\Backend\Model\Session')->setFormData($data);

                return $resultRedirect->setPath('*/*/reply', ['id' => $id]);
            }
        }
        $this->_redirect('*/*/listquestions');
    }
}
