<?php
/**
 * @category  Extendware
 *
 * @copyright 2020 Extendware
 */
namespace Extendware\AskQuestion\Model;

class Question extends \Magento\Framework\Model\AbstractModel
{
    protected function _construct()
    {
        $this->_init('Extendware\AskQuestion\Model\ResourceModel\Question');
    }

    public function getDefaultValues()
    {
        $values = [];

        return $values;
    }

    public function getHelperFile()
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();

        return $objectManager->create('\Extendware\AskQuestion\Helper\Data');
    }

    public function sendEmail()
    {
        /** @var \Extendware\AskQuestion\Helper\Data $helper */
        $helper = $this->getHelperFile();
        $helper->sendAnswerEmail($this->getEmail(), $this->getAnswer(), $this->getQuestion(), $this->getCreatedAt());

        return $this;
    }

    public function sendEmailToAdmin()
    {
        /** @var \Extendware\AskQuestion\Helper\Data $helper */
        $helper = $this->getHelperFile();
        $helper->sendEmailToAdmin($this->getName(), $this->getProductSku(), $this->getQuestion());

        return $this;
    }
}
