<?php
namespace Extendware\AskQuestion\ViewModel;

use Extendware\AskQuestion\Helper\Data;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Widget\Model\Template\Filter;

class Form implements ArgumentInterface
{
    /**
     * @var RequestInterface
     */
    private RequestInterface $request;

    /**
     * @var ProductRepositoryInterface
     */
    private $productRepository;

    // @var Data
    private $questionHelper;

    /**
     * @var Filter
     */
    private Filter $templateProcessor;

    public function __construct(
        ProductRepositoryInterface $productRepository,
        Data $questionHelper,
        Filter $templateProcessor,
        RequestInterface $request
    ) {
        $this->questionHelper = $questionHelper;
        $this->templateProcessor = $templateProcessor;
        $this->request = $request;
        $this->productRepository = $productRepository;
    }

    /**
     * @return mixed|string|null
     */
    public function getInfoContent()
    {
        $data = $this->questionHelper->getPopupContent();

        if ($data) {
            return $this->templateProcessor->filter($data);
        }

        return $data;
    }

    /**
     * @throws NoSuchEntityException
     *
     * @return ProductInterface
     */
    public function getProduct()
    {
        $productId = $this->getCurrentProductId();

        return $this->productRepository->getById($productId);
    }

    /**
     * @return int|null
     */
    private function getCurrentProductId()
    {
        return $this->request->getParam('id', false);
    }
}
