<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);

namespace Extendware\AttachmentPathSegment\Api;

use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;
use Magento\Framework\Api\SearchCriteriaInterface;

interface AttachmentPathSegmentRepositoryInterface
{
    /**
     * @param int $id
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function get(int $id): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
      * @param \Magento\Framework\Api\SearchCriteriaInterface $criteria
      * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentSearchResultsInterface
      */
    public function getList(SearchCriteriaInterface $criteria): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentSearchResultsInterface;

    /**
     * @param \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface $entity
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function save(AttachmentPathSegmentInterface $entity): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
      * @param \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface $entity
      * @return bool
      */
    public function delete(AttachmentPathSegmentInterface $entity): bool;

    /**
     * @param int $id
     * @return bool
     */
    public function deleteById(int $id): bool;
}
