<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);

namespace Extendware\AttachmentPathSegment\Api\Data;

use Magento\Framework\Api\ExtensibleDataInterface;

interface AttachmentPathSegmentInterface extends ExtensibleDataInterface
{
    public const SEGMENT_ID = 'segment_id';
    public const TERM_NAME = 'term_name';
    public const FRONT_LABEL = 'front_label';
    public const STORE_ID = 'store_id';

    /**
     * @return int|null
     */
    public function getSegmentId(): ?int;

    /**
     * @param int $segment_id
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function setSegmentId(int $segment_id): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
     * @return string|null
     */
    public function getTermName(): ?string;

    /**
     * @param string $term_name
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function setTermName(string $term_name): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
     * @return string|null
     */
    public function getFrontLabel(): ?string;

    /**
     * @param string $front_label
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function setFrontLabel(string $front_label): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
     * @return int|null
     */
    public function getStoreId(): ?int;

    /**
     * @param int $store_id
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface
     */
    public function setStoreId(int $store_id): \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;

    /**
     * @return \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentExtensionInterface|null
     */
    public function getExtensionAttributes(): ?\Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentExtensionInterface;

    /**
     * @param \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentExtensionInterface $extensionAttributes
     * @return static
     */
    public function setExtensionAttributes(
        \Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentExtensionInterface $extensionAttributes
    ): static;
}
