<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Extendware\AttachmentPathSegment\Block\Adminhtml\AttachmentPathSegment\Edit;

use Extendware\AttachmentPathSegment\Api\AttachmentPathSegmentRepositoryInterface;
use Magento\Backend\Block\Widget\Context;
use Magento\Framework\Exception\NoSuchEntityException;

class GenericButton
{
    /**
     * @var Context
     */
    protected $context;

    /**
     * @var AttachmentPathSegmentRepositoryInterface
     */
    protected $repository;

    /**
     * @param Context $context
     * @param AttachmentPathSegmentRepositoryInterface $repository
     */
    public function __construct(
        Context $context,
        AttachmentPathSegmentRepositoryInterface $repository
    ) {
        $this->context = $context;
        $this->repository = $repository;
    }

    public function getId(): ?int
    {
        $id = $this->context->getRequest()->getParam('segment_id');
        if (!$id) {
            return null;
        }

        try {
            return $this->repository->get($id)->getId();
        } catch (NoSuchEntityException $e) {
        }
        return null;
    }

    /**
     * Generate url by route and parameters
     *
     * @param   string $route
     * @param   array $params
     * @return  string
     */
    public function getUrl($route = '', $params = [])
    {
        return $this->context->getUrlBuilder()->getUrl($route, $params);
    }
}
