<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);

namespace Extendware\AttachmentPathSegment\Controller\Adminhtml\AttachmentPathSegment;

use Extendware\AttachmentPathSegment\Model\AttachmentPathSegment;
use Extendware\AttachmentPathSegment\Model\AttachmentPathSegmentFactory;
use Extendware\AttachmentPathSegment\Model\ResourceModel\AttachmentPathSegment as ModelResource;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Redirect;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\ResultFactory;

class Delete extends Action implements HttpPostActionInterface
{
    public const ADMIN_RESOURCE = 'Extendware_AttachmentPathSegment::AttachmentPathSegment_delete';

    private AttachmentPathSegmentFactory $modelFactory;
    private ModelResource $modelResource;

    public function __construct(
        Context $context,
        AttachmentPathSegmentFactory $modelFactory,
        ModelResource $modelResource
    ) {
        parent::__construct($context);

        $this->modelFactory = $modelFactory;
        $this->modelResource = $modelResource;
    }

    /** @thows \Exception */
    public function execute(): Redirect
    {
        try {
            $id = $this->getRequest()->getParam('segment_id');
            /** @var AttachmentPathSegment $model */
            $model = $this->modelFactory->create();
            $this->modelResource->load($model, $id);
            if ($model->getId()) {
                $this->modelResource->delete($model);
                $this->messageManager->addSuccessMessage(__('The record has been deleted.'));
            } else {
                $this->messageManager->addErrorMessage(__('The record does not exist.'));
            }
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        /** @var Redirect $redirect */
        $redirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

        return $redirect->setPath('*/*');
    }
}
