<?php
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
declare(strict_types=1);

namespace Extendware\AttachmentPathSegment\Controller\Adminhtml\AttachmentPathSegment;

use Extendware\AttachmentPathSegment\Api\AttachmentPathSegmentRepositoryInterface;
use Extendware\AttachmentPathSegment\Model\AttachmentPathSegmentFactory;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\RedirectFactory;
use Magento\Framework\Message\ManagerInterface;

class Save implements HttpPostActionInterface
{
    const ADMIN_RESOURCE = 'Extendware_AttachmentPathSegment::AttachmentPathSegment_save';

    public function __construct(
        private readonly RequestInterface $request,
        private readonly ManagerInterface $messageManager,
        private readonly RedirectFactory $resultRedirectFactory,
        private readonly AttachmentPathSegmentRepositoryInterface $repository,
        private readonly AttachmentPathSegmentFactory $modelFactory,
    ) {
    }

    public function execute()
    {
        $id = $this->request->getParam('segment_id');
        $data = $this->request->getPostValue();

        $model = $this->modelFactory->create();
        if ($id) {
            $model = $this->repository->get((int)$id);
        }

        $model->setData($data);

        try {
            $model = $this->repository->save($model);
            $this->messageManager->addSuccessMessage(__('You saved the item.'));
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e->getMessage());
            return $this->resultRedirectFactory->create()->setPath('*');
        }

        return $this->resultRedirectFactory->create()
            ->setPath('*/*/edit', ['segment_id' => $model->getId()]);
    }
}
