<?php declare(strict_types=1);
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Extendware\AttachmentPathSegment\Model;

use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentExtensionInterface;
use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;
use Magento\Framework\Model\AbstractExtensibleModel;

class AttachmentPathSegment extends AbstractExtensibleModel implements AttachmentPathSegmentInterface
{
    /**
     * @inheritdoc
     */
    protected function _construct(): void
    {
        $this->_init(ResourceModel\AttachmentPathSegment::class);
    }

    /**
     * Get segment_id
     * @return int|null
     */
    public function getSegmentId(): ?int
    {
        return $this->getData(self::SEGMENT_ID);
    }

    /**
     * Set segment_id
     * @param int $segment_id
     * @return AttachmentPathSegmentInterface
     */
    public function setSegmentId(int $segment_id): AttachmentPathSegmentInterface
    {
        return $this->setData(self::SEGMENT_ID, $segment_id);
    }

    /**
     * Get term_name
     * @return string|null
     */
    public function getTermName(): ?string
    {
        return $this->getData(self::TERM_NAME);
    }

    /**
     * Set term_name
     * @param string $term_name
     * @return AttachmentPathSegmentInterface
     */
    public function setTermName(string $term_name): AttachmentPathSegmentInterface
    {
        return $this->setData(self::TERM_NAME, $term_name);
    }

    /**
     * Get front_label
     * @return string|null
     */
    public function getFrontLabel(): ?string
    {
        return $this->getData(self::FRONT_LABEL);
    }

    /**
     * Set front_label
     * @param string $front_label
     * @return AttachmentPathSegmentInterface
     */
    public function setFrontLabel(string $front_label): AttachmentPathSegmentInterface
    {
        return $this->setData(self::FRONT_LABEL, $front_label);
    }

    /**
     * Get store_id
     * @return int|null
     */
    public function getStoreId(): ?int
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * Set store_id
     * @param int $store_id
     * @return AttachmentPathSegmentInterface
     */
    public function setStoreId(int $store_id): AttachmentPathSegmentInterface
    {
        return $this->setData(self::STORE_ID, $store_id);
    }

    /**
     * Retrieve existing extension attributes object or create a new one.
     * @return AttachmentPathSegmentExtensionInterface|null
     */
    public function getExtensionAttributes(): ?AttachmentPathSegmentExtensionInterface
    {
        return $this->_getExtensionAttributes();
    }

    /**
     * Set an extension attributes object.
     * @param AttachmentPathSegmentExtensionInterface $extensionAttributes
     * @return $this
     */
    public function setExtensionAttributes(
        AttachmentPathSegmentExtensionInterface $extensionAttributes
    ): static {
        return $this->_setExtensionAttributes($extensionAttributes);
    }
}
