<?php declare(strict_types=1);
/*
 *
 *  * web-vision GmbH
 *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  * versions in the future. If you wish to customize Magento for your
 *  * needs please refer to https://www.web-vision.de for more information.
 *  * @category    Extendware
 *  * @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 *  * @author      Fenil Timbadiya
 *
 */
namespace Extendware\AttachmentPathSegment\Model;

use Extendware\AttachmentPathSegment\Api\AttachmentPathSegmentRepositoryInterface;
use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentInterface;
use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentSearchResultsInterface;
use Extendware\AttachmentPathSegment\Api\Data\AttachmentPathSegmentSearchResultsInterfaceFactory;
use Extendware\AttachmentPathSegment\Model\ResourceModel\AttachmentPathSegment as ResourceAttachmentPathSegment;
use Extendware\AttachmentPathSegment\Model\ResourceModel\AttachmentPathSegment\CollectionFactory as AttachmentPathSegmentCollectionFactory;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;

class AttachmentPathSegmentRepository implements AttachmentPathSegmentRepositoryInterface
{
    public function __construct(
        private readonly ResourceAttachmentPathSegment $resource,
        private readonly AttachmentPathSegmentFactory $attachmentPathSegmentFactory,
        private readonly AttachmentPathSegmentCollectionFactory $attachmentPathSegmentCollectionFactory,
        private readonly CollectionProcessorInterface $collectionProcessor,
        private readonly AttachmentPathSegmentSearchResultsInterfaceFactory $searchResultsFactory,
        private readonly JoinProcessorInterface $extensionAttributesJoinProcessor
    ) {
    }

    /**
     * {@inheritdoc}
     */
    public function save(AttachmentPathSegmentInterface $entity): AttachmentPathSegmentInterface
    {
        try {
            $this->resource->save($entity);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the attachmentPathSegment: %1',
                $exception->getMessage()
            ));
        }
        return $entity;
    }

    /**
     * {@inheritdoc}
     */
    public function get(int $id): AttachmentPathSegmentInterface
    {
        $attachmentPathSegment = $this->attachmentPathSegmentFactory->create();
        $this->resource->load($attachmentPathSegment, $id);
        if (!$attachmentPathSegment->getId()) {
            throw new NoSuchEntityException(__('AttachmentPathSegment with id "%1" does not exist.', $id));
        }
        return $attachmentPathSegment;
    }

    /**
     * {@inheritdoc}
     */
    public function getList(SearchCriteriaInterface $criteria): AttachmentPathSegmentSearchResultsInterface
    {
        $collection = $this->attachmentPathSegmentCollectionFactory->create();

        $this->extensionAttributesJoinProcessor->process(
            $collection,
            AttachmentPathSegmentInterface::class
        );

        $this->collectionProcessor->process($criteria, $collection);

        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);

        $items = [];
        foreach ($collection as $model) {
            $items[] = $model;
        }

        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * {@inheritdoc}
     */
    public function delete(AttachmentPathSegmentInterface $entity): bool
    {
        try {
            $attachmentPathSegmentModel = $this->attachmentPathSegmentFactory->create();
            $this->resource->load($attachmentPathSegmentModel, $entity->getEntityId());
            $this->resource->delete($attachmentPathSegmentModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the AttachmentPathSegment: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function deleteById(int $id): bool
    {
        return $this->delete($this->get($id));
    }
}
