<?php

namespace Extendware\AutoRelatedProducts\Block\Adminhtml\Catalog\ConditionField;

use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\App\ObjectManager;

class ProductDisplayCondition extends Generic implements TabInterface
{
    protected $_rendererFieldset;

    protected $_actions;

    protected $_nameInLayout = 'actions';

    private $ruleFactory;

    private $autoRelatedFactory;

    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Rule\Block\Actions $actions,
        \Magento\Backend\Block\Widget\Form\Renderer\Fieldset $rendererFieldset,
        \Extendware\AutoRelatedProducts\Model\AutoRelatedFactory $autoRelatedFactory,
        array $data = []
    ) {
        $this->_rendererFieldset = $rendererFieldset;
        $this->_actions = $actions;
        $this->autoRelatedFactory = $autoRelatedFactory;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    private function getRuleFactory()
    {
        if ($this->ruleFactory === null) {
            //@codingStandardsIgnoreStart
            $this->ruleFactory = ObjectManager::getInstance()->get('Extendware\AutoRelatedProducts\Model\AutoRelatedFactory');
            //@codingStandardsIgnoreEnd
        }
        return $this->ruleFactory;
    }

    public function getTabClass()
    {
        return null;
    }

    public function getTabUrl()
    {
        return null;
    }

    public function isAjaxLoaded()
    {
        return false;
    }

    public function getTabLabel()
    {
        return __('Conditions');
    }

    public function getTabTitle()
    {
        return __('Conditions');
    }

    public function canShowTab()
    {
        return true;
    }

    public function isHidden()
    {
        return false;
    }

    protected function _prepareForm()
    {
        $model = $this->_coreRegistry->registry('current_rule');
        $form = $this->addTabToForm($model);
        $this->setForm($form);

        return parent::_prepareForm();
    }

    protected function addTabToForm(
        $model,
        $fieldsetId = 'action_serialized_field',
        $formName = 'auto_related_products_form'
    ) {
        if (!$model) {
            $id = $this->getRequest()->getParam('rule_id');
            $model = $this->getRuleFactory()->create();
            $model->load($id);
        }
        $conditionsFieldSetId = $model->getActionFieldSetId($formName);
        $newChildUrl = $this->getUrl(
            'autorelatedproducts/index/newActionHtml/form/' . $conditionsFieldSetId,
            ['form_namespace' => $formName]
        );
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create();
        $form->setHtmlIdPrefix('rule_');
        $renderer = $this->_rendererFieldset->setTemplate(
            'Magento_CatalogRule::promo/fieldset.phtml'
        )->setNewChildUrl(
            $newChildUrl
        )->setFieldSetId(
            $conditionsFieldSetId
        );

        $fieldset = $form->addFieldset(
            $fieldsetId,
            [
                'legend' => __(
                    'Apply the rule only if the following conditions are met (leave blank for all products).'
                ),
            ]
        )->setRenderer(
            $renderer
        );
        $fieldset->addField(
            'action',
            'text',
            [
                'name' => 'action',
                'label' => __('Conditions'),
                'title' => __('Conditions'),
                'required' => true,
                'data-form-part' => $formName,
            ]
        )->setRule(
            $model
        )->setRenderer(
            $this->_actions
        );

        $form->setValues($model->getData());
        $this->setActionFormName($model->getActions(), $formName, $conditionsFieldSetId);
        return $form;
    }
    private function setActionFormName(\Magento\Rule\Model\Condition\AbstractCondition $conditions, $formName, $conditionsFieldSetId)
    {
        $conditions->setFormName($formName);
        $conditions->setJsFormObject($conditionsFieldSetId);
        if ($conditions->getActions() && is_array($conditions->getActions())) {
            foreach ($conditions->getActions() as $condition) {
                $this->setActionFormName($condition, $formName, $conditionsFieldSetId);
            }
        }
    }
}
