<?php

namespace Extendware\AutoRelatedProducts\Block\Adminhtml\Edit\Button;

use Magento\Framework\View\Element\UiComponent\Control\ButtonProviderInterface;

class ApplyButton extends Generic implements ButtonProviderInterface
{
    public function getButtonData()
    {
        return [
            'label' => __('Save and Apply Rule'),
            'class' => 'save',
            'on_click' => '',
            'sort_order' => 50,
            'data_attribute' => [
                'mage-init' => [
                    'Magento_Ui/js/form/button-adapter' => [
                        'actions' => [
                            [
                                'targetName' => 'auto_related_products_form.auto_related_products_form',
                                'actionName' => 'save',
                                'params' => [
                                    true,
                                    [
                                        'auto_apply' => 1,
                                    ],
                                ],
                            ],
                        ],
                    ],
                ],

            ],
        ];
    }
}
