<?php

namespace Extendware\AutoRelatedProducts\Controller\Adminhtml\Index;

use Magento\Framework\Controller\ResultFactory;

class ApplyRule extends \Magento\Backend\App\Action
{
    protected $resultPageFactory;
    protected $autorelatedCollection;
    protected $productCollectionFactory;
    protected $productloader;
    protected $productLinks;
    protected $autorelatedListFactory;
    protected $autorelatedListModel;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelated\CollectionFactory $autorelatedCollection,
        \Extendware\AutoRelatedProducts\Model\AutoRelatedFactory $autorelatedFactory,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Magento\Catalog\Model\ProductFactory $productloader,
        \Magento\Catalog\Api\Data\ProductLinkInterfaceFactory $productLinks,
        \Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelatedListFactory $autorelatedListFactory,
        \Extendware\AutoRelatedProducts\Model\AutoRelatedListFactory $autorelatedListModel,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory
    ) {
        parent::__construct($context);
        $this->autorelatedCollection = $autorelatedCollection;
        $this->autorelatedFactory = $autorelatedFactory;
        $this->productCollectionFactory = $productCollectionFactory;
        $this->productloader = $productloader;
        $this->productLinks = $productLinks;
        $this->autorelatedListFactory = $autorelatedListFactory;
        $this->autorelatedListModel = $autorelatedListModel;
        $this->resultPageFactory = $resultPageFactory;
    }

    public function execute()
    {
        // truncate all rules products list data
        $this->autorelatedListFactory->create()->truncateTable();
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        $ruleData = $this->autorelatedCollection->create();
        $ruleData->addFieldToFilter('rule_status', ['eq' => 1]);
        $ruleCount = 0;
        foreach ($ruleData as $ruleKey => $ruleValue) {
            $ruleConditionData = $this->autorelatedFactory->create();
            $ruleConditionData->load($ruleValue->getId());
            $productCollection = $this->productCollectionFactory->create();
            $productCollection->addAttributeToSelect('*');
            $productSelectedIds = [];
            $productDisplayIds = [];
            foreach ($productCollection as $product) {
                // check condition for Products Selection condition
                if ($ruleConditionData->getConditions()->validate($product)) {
                    $productSelectedIds[] = $product->getId();
                }
                // check condition for Products Display condition
                if ($ruleConditionData->getActions()->validate($product)) {
                    $productDisplayIds[] = $product->getId();
                }
            }
            $productSelectedCount = count($productSelectedIds);
            $productDisplayCount = count($productDisplayIds);
            $maxCount = 0;
            if ($productDisplayCount >= $productSelectedCount) {
                $maxCount = $productDisplayCount;
            } else {
                $maxCount = $productSelectedCount;
            }
            // add product to product list
            for ($x = 0; $x <= $maxCount; $x++) {
                $isSave = 0;
                $prdList = $this->autorelatedListModel->create();
                if (isset($productDisplayIds[$x])) {
                    $prdList->setShowProducts($productDisplayIds[$x]);
                    $isSave = 1;
                }
                if (isset($productSelectedIds[$x])) {
                    $prdList->setSelectedProduct($productSelectedIds[$x]);
                    $isSave = 1;
                }
                if ($isSave) {
                    $prdList->setRuleId($ruleValue->getId());
                    $prdList->save();
                }
            }
            $ruleCount++;
        }
        // check rule is exist or not
        if ($ruleCount) {
            $this->messageManager->addSuccess(__('Auto related products rules updated successfully.'));
        } else {
            $this->messageManager->addWarning(__('Please add new auto related products.'));
        }
        return $resultRedirect->setPath('autorelatedproducts/index/index');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Extendware_AutoRelatedProducts::main_menu');
    }
}
