<?php

namespace Extendware\AutoRelatedProducts\Controller\Adminhtml\Index;

use Magento\Backend\App\Action;
use Extendware\AutoRelatedProducts\Model\AutoRelatedFactory;

class Delete extends Action
{
    protected $productLabelmodel;

    public function __construct(
        Action\Context $context,
        AutoRelatedFactory $productLabelmodel
    ) {
        parent::__construct($context);
        $this->productLabelmodel = $productLabelmodel;
    }

    public function execute()
    {
        $id = $this->getRequest()->getParam('rule_id');
        $resultRedirect = $this->resultRedirectFactory->create();
        if ($id) {
            try {
                $model = $this->productLabelmodel->create();
                $model->load($id);
                $model->delete();
                $this->messageManager->addSuccess(__('The rule is successfully deleted'));
                return $resultRedirect->setPath('*/*/');
            } catch (\Exception $e) {
                $this->messageManager->addError($e->getMessage());
                return $resultRedirect->setPath('*/*/edit', ['rule_id' => $id]);
            }
        }
        $this->messageManager->addError(__('The rule does not exist'));
        return $resultRedirect->setPath('*/*/');
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Extendware_AutoRelatedProducts::main_menu');
    }
}
