<?php

namespace Extendware\AutoRelatedProducts\Controller\Adminhtml\Index;

use Magento\Framework\Phrase;

class Index extends \Magento\Backend\App\Action
{
    protected $resultPageFactory;

    protected $indexerFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Indexer\Model\IndexerFactory $indexerFactory,
    ) {
        parent::__construct($context);
        $this->resultPageFactory = $resultPageFactory;
        $this->indexerFactory = $indexerFactory;
    }

    public function execute()
    {
        $resultPage = $this->resultPageFactory->create();

        // Show indexer status message
        $this->getIndexerCount();

        $resultPage->getConfig()->getTitle()->prepend(__('Manage Auto Related Products Rules'));
        return $resultPage;
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Extendware_AutoRelatedProducts::main_menu');
    }

    public function getIndexerCount()
    {
        try {
            $indexer = $this->indexerFactory->create();
            $indexer->load('auto_related_product');
            $view = $indexer->getView();

            $state = $view->getState()->loadByView($view->getId());
            $changelog = $view->getChangelog()->setViewId($view->getId());
            $currentVersionId = $changelog->getVersion();
            $count = count($changelog->getList($state->getVersionId(), $currentVersionId));

            if($count){
                $text = new Phrase(
                    "The indexer is currently processing %count records.",
                    [
                        'count' => $count,
                    ]
                );
                $this->messageManager->addNotice(__($text));
            } else {
                $this->messageManager->addSuccess(__("All data has been successfully synchronized by the indexer."));
            }
        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage(__($e->getMessage()));
        }
    }
}
