<?php

namespace Extendware\AutoRelatedProducts\Controller\Adminhtml\Index;

use Extendware\AutoRelatedProducts\Model\AutoRelatedFactory;
use Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelated\CollectionFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use Magento\Ui\Component\MassAction\Filter;

class MassDelete extends \Magento\Backend\App\Action
{
    protected $filter;
    protected $collectionFactory;
    protected $productlabelFactory;

    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory,
        AutoRelatedFactory $productlabelFactory
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        $this->productlabelFactory = $productlabelFactory;
        parent::__construct($context);
    }

    public function execute()
    {
        $selected = $this->getRequest()->getParam('rule_id');
        if ($selected) {
            $collection = $this->collectionFactory->create();
        } else {
            $collection = $this->filter->getCollection($this->collectionFactory->create());
        }
        $lableData = $this->collectionFactory->create();
        foreach ($lableData as $value) {
            $templateId[] = $value['rule_id'];
        }
        $parameterData = $this->getRequest()->getParams('rule_id');
        $selectedAppsid = $this->getRequest()->getParams('rule_id');
        if (array_key_exists("selected", $parameterData)) {
            $selectedAppsid = $parameterData['selected'];
        }
        if (array_key_exists("excluded", $parameterData)) {
            if ($parameterData['excluded'] == 'false') {
                $selectedAppsid = $templateId;
            } else {
                $selectedAppsid = array_diff($templateId, $parameterData['excluded']);
            }
        }
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $collection = $this->collectionFactory->create();
        $collection->addFieldToFilter('rule_id', ['in' => $selectedAppsid]);
        $delete = 0;
        $model = [];
        foreach ($collection as $item) {
            $this->deleteById($item->getId());
            $delete++;
        }
        $this->messageManager->addSuccess(__('A total of %1 Records have been deleted.', $delete));
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath('autorelatedproducts/index/index');
    }

    public function deleteById($id)
    {
        $item = $this->productlabelFactory->create();
        $item->load($id);
        $item->delete();
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Extendware_AutoRelatedProducts::main_menu');
    }
}
