<?php

namespace Extendware\AutoRelatedProducts\Controller\Adminhtml\Index;

use Extendware\AutoRelatedProducts\Model\AutoRelatedFactory;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;

class Save extends \Magento\Backend\App\Action
{

    protected $ruledatamodel;
    protected $dataPersistor;
    protected $productCollectionFactory;
    protected $autorelatedListModel;

    public function __construct(
        Action\Context $context,
        \Magento\Catalog\Model\ResourceModel\Product\CollectionFactory $productCollectionFactory,
        \Extendware\AutoRelatedProducts\Model\AutoRelatedListFactory $autorelatedListModel,
        AutoRelatedFactory $ruledatamodel
    ) {
        $this->productCollectionFactory = $productCollectionFactory;
        $this->autorelatedListModel = $autorelatedListModel;
        $this->ruledatamodel = $ruledatamodel;
        parent::__construct($context);
    }

    public function execute()
    {
        $data = $this->getRequest()->getPostValue();
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);

        if (!empty($data['customer_group'])) {
            $data['customer_group'] = implode(",", $data['customer_group']);
        }
        if (!empty($data['storeviews'])) {
            $data['storeviews'] = implode(",", $data['storeviews']);
        }
        // set catelog rule base condition for condition 1
        if (isset($data['rule']['conditions'])) {
            $data['conditions'] = $data['rule']['conditions'];
        }
        // set catelog rule base action for Condition 2
        if (isset($data['rule']['actions'])) {
            $data['actions'] = $data['rule']['actions'];
        }

        // set rule to unset
        if (isset($data['rule'])) {
            unset($data['rule']);
        }
        // save product label data
        try {
            $model = $this->ruledatamodel->create();
            $id = $this->getRequest()->getParam('rule_id');
            if ($id) {
                $model->load($id);
            }
            if (!$model->getId() && $id) {
                $this->messageManager->addErrorMessage(__('This rule is no longer exists.'));
                return $resultRedirect->setPath('autorelatedproducts/index/index');
            }
            $model->loadPost($data);
            $model->save();
            $this->messageManager->addSuccess(__('Row data has been successfully saved.'));
            // get Rule Apply status
            $isApply = $this->getRequest()->getParam('auto_apply');
            if ($isApply) {
                $this->applyConditionRule($model->getId());
            }
            if ($this->getRequest()->getParam('back')) {
                if ($this->getRequest()->getParam('back') == 'add') {
                    return $resultRedirect->setPath('autorelatedproducts/index/add');
                } else {
                    return $resultRedirect->setPath(
                        'autorelatedproducts/index/edit',
                        [
                            'rule_id' => $model->getId(),
                        ]
                    );
                }
            }
        } catch (\Exception $e) {
            $this->messageManager->addException($e, __('Something went wrong while saving the data.'));
            return $resultRedirect->setPath('autorelatedproducts/index/add');
        }
        return $resultRedirect->setPath('autorelatedproducts/index/index');
    }

    public function applyConditionRule($ruleId)
    {
        // clear old rule product ids
        $ruleList = $this->autorelatedListModel->create()->getCollection();
        $ruleList->addFieldToFilter('rule_id', $ruleId);
        foreach ($ruleList as $ruleListKey => $ruleListValue) {
            $this->autorelatedListModel->create()->load($ruleListValue->getId())->delete();
        }
        $ruleData = $this->ruledatamodel->create()->load($ruleId);
        $productCollection = $this->productCollectionFactory->create();
        $productCollection->addAttributeToSelect('*');
        $productSelectedIds = [];
        $productDisplayIds = [];
        foreach ($productCollection as $product) {
            $prdList = $this->autorelatedListModel->create();
            // check condition for Products Selection condition
            if ($ruleData->getConditions()->validate($product)) {
                $productSelectedIds[] = $product->getId();
            }
            // check condition for Products Display condition
            if ($ruleData->getActions()->validate($product)) {
                $productDisplayIds[] = $product->getId();
            }
        }
        $productDisplayCount = count($productDisplayIds);
        $productSelectedCount = count($productSelectedIds);
        $maxCount = 0;
        if ($productDisplayCount >= $productSelectedCount) {
            $maxCount = $productDisplayCount;
        } else {
            $maxCount = $productSelectedCount;
        }
        for ($x = 0; $x <= $maxCount; $x++) {
            $isSave = 0;
            $prdList = $this->autorelatedListModel->create();
            if (isset($productDisplayIds[$x])) {
                $prdList->setShowProducts($productDisplayIds[$x]);
                $isSave = 1;
            }
            if (isset($productSelectedIds[$x])) {
                $prdList->setSelectedProduct($productSelectedIds[$x]);
                $isSave = 1;
            }
            if ($isSave) {
                $prdList->setRuleId($ruleId);
                $prdList->save();
            }
        }
        $this->messageManager->addSuccess(__('Auto related products rule updated successfully.'));
    }

    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Extendware_AutoRelatedProducts::main_menu');
    }
}
