<?php

namespace Extendware\AutoRelatedProducts\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\ScopeInterface;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Extendware\AutoRelatedProducts\Model\AutoRelatedProductManager;
use Magento\Framework\Registry;
use Magento\Customer\Model\Session;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Catalog\Model\ProductFactory;
use Magento\Framework\Data\Form\FormKey;

class Data extends AbstractHelper
{
    public const AUTO_RELATED_STATUS = 'autorelated/general_option/module_status';

    public const ALL_CUSTOMER_GROUP_ID = 32000;

    protected $scopeConfig;

    protected $autoRelatedProductManager;

    protected $registry;

    protected $customerSession;

    protected $storeManager;

    protected $productFactory;

    protected $formKey;

    public function __construct(
        ScopeConfigInterface $scopeConfig,
        AutoRelatedProductManager $autoRelatedProductManager,
        Registry $registry,
        Session $customerSession,
        StoreManagerInterface $storeManager,
        ProductFactory $productFactory,
        FormKey $formKey
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->autoRelatedProductManager = $autoRelatedProductManager;
        $this->registry = $registry;
        $this->customerSession = $customerSession;
        $this->storeManager = $storeManager;
        $this->productFactory = $productFactory;
        $this->formKey = $formKey;
    }

    public function getModuleStatus()
    {
        return $this->scopeConfig->getValue(self::AUTO_RELATED_STATUS, ScopeInterface::SCOPE_STORE);
    }

    public function getAutoRelatedProductManager()
    {
        return $this->autoRelatedProductManager;
    }

    public function getProduct($productId = false)
    {
        if($productId) {
            return $this->productFactory->create()->load($productId);
        }

        return $this->registry->registry('product');
    }

    public function getAppliedRule($blockType)
    {
        // Check module status
        if(!$this->getModuleStatus()){
            return false;
        }

        // Get Product
        $product = $this->getProduct();

        $productId = $product?->getId();

        if(!$productId){
            return false;
        }

        // Get applicable rule-product entries
        $ruleProductIdCollection = $this->autoRelatedProductManager->getRuleSelectedProductCollection($productId);
        if(!$ruleProductIdCollection->getSize()){
            return false;
        }

        // Extract rule IDs
        $ruleIds = $this->extractArrayValues($ruleProductIdCollection->getData(), 'rule_id');

        // Fetch rule details for the block type
        $ruleCollection = $this->autoRelatedProductManager->getRuleDataModalCollection($ruleIds, $blockType);
        $ruleCollection->addFieldToSelect(['rule_id','customer_group','storeviews','block_title','block_layout','block_position']);
        if(!$ruleCollection->getSize()){
            return false;
        }

        // Match rules based on customer group and store view
        foreach($ruleCollection as $rule) {
            if(
                $this->getCustomerGroupStatus($rule->getCustomerGroup()) &&
                $this->getStoreStatus($rule->getStoreviews())
            ) {
                return $rule;
            }
        }

        return false;
    }

    public function getAppliedProductIds($blockType)
    {
        // Check module status
        if(!$this->getModuleStatus()){
            return false;
        }

        // Get Applied Rule
        $rule = $this->getAppliedRule($blockType);
        if(!$rule) {
            return false;
        }

        $showProducts = $this->autoRelatedProductManager->getRuleShowProductsCollection($rule->getRuleId());
        if(!$showProducts->getSize()){
            return false;
        }

        $showProductIds = $this->extractArrayValues($showProducts->getData(), 'show_products');
        if(empty($showProductIds)){
            return false;
        }

        $rule->setProductIds($showProductIds);

        return $rule;
    }

    public function getCustomerGroupId()
    {
        return $this->customerSession->isLoggedIn()
            ? (int) $this->customerSession->getCustomer()->getCustomerGroupId()
            : 0;
    }

    public function getCustomerGroupStatus($ruleGroups)
    {
        $allGroups = $this->getStringToArray($ruleGroups);
        $currntGroup = $this->getCustomerGroupId();

        // check group for all or not
        if (in_array(self::ALL_CUSTOMER_GROUP_ID, $allGroups)) {
            return true;
        }

        //check for current group status
        if (in_array($currntGroup, $allGroups)) {
            return true;
        }

        return false;
    }

    public function getStoreStatus($ruleStore)
    {
        $ruleStore = $this->getStringToArray($ruleStore);
        $currentStore = $this->storeManager->getStore()->getId();
        // check for all store views
        if (in_array(0, $ruleStore)) {
            return true;
        }
        // check for Current store view
        if (in_array($currentStore, $ruleStore)) {
            return true;
        }

        return false;
    }

    public function getStringToArray($string)
    {
        return explode(',', $string);
    }

    public function extractArrayValues($array, $columnName)
    {
        return array_filter(array_column($array, $columnName));
    }

    public function getBlockPositions()
    {
        return $this->blockPositions->getOptionArray();
    }

    /**
     * Get form key
     *
     * @return string
     */
    public function getFormKey()
    {
        return $this->formKey->getFormKey();
    }
}
