<?php

namespace Extendware\AutoRelatedProducts\Model;

use Extendware\AutoRelatedProducts\Model\AutoRelatedFactory;
use Magento\Backend\App\Action;
use Magento\Framework\Controller\ResultFactory;
use Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelatedListFactory as AutoRelatedListResourceModel;
use Extendware\AutoRelatedProducts\Model\AutoRelatedListFactory as AutoRelatedListModel;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;
use Extendware\AutoRelatedProducts\Model\Config\Source\IndexerStatus;

class AutoRelatedProductManager
{
    protected $autoRelatedListModel;
    protected $autoRelatedListResourceModel;
    protected $ruledatamodel;

    public function __construct(
        AutoRelatedListModel $autoRelatedListModel,
        AutoRelatedListResourceModel $autoRelatedListResourceModel,
        AutoRelatedFactory $ruledatamodel
    ) {
        $this->autoRelatedListModel = $autoRelatedListModel;
        $this->autoRelatedListResourceModel = $autoRelatedListResourceModel;
        $this->ruledatamodel = $ruledatamodel;
    }

    public function processAll($ruleIds = [])
    {
        $ruleData = $this->getRuleDataModalCollection($ruleIds);
        if($ruleData->getSize()) {
            foreach($ruleData as $rule) {
                $this->saveRuleProductsBulkIds(
                        $rule->getRuleId(),
                        $rule->getConditionMatchProductIds(),
                        $rule->getActionMatchProductIds()
                    );
            }
        }
    }

    public function getRuleDataModalCollection($ruleIds = [] , $blockType = false)
    {
        if(!empty($ruleIds)) {
            $ruleCollection = $this->ruledatamodel->create()->getCollection()
                        ->addFieldToFilter('rule_status', ['eq' => 1])
                        ->addFieldToFilter('rule_id', ['in' => $ruleIds]);

            if ($blockType !== false) {
                $ruleCollection->addFieldToFilter('block_position', $blockType);
            }

            return $ruleCollection->setOrder('rule_priority','DESC');
        }

        return $this->ruledatamodel->create()->getCollection();
    }

    public function getRuleDataModel($ruleId = 0)
    {
        if($ruleId){
            return $this->ruledatamodel->create()->load($ruleId);
        }

        return $this->ruledatamodel->create();
    }

    public function getRuleSelectedProductCollection($productId)
    {
        return $this->autoRelatedListModel->create()->getCollection()
                                ->addFieldToSelect(['rule_id'])
                                ->addFieldToFilter('selected_product', ['eq' => $productId]);
    }

    public function getRuleShowProductsCollection($ruleId)
    {
        return $this->autoRelatedListModel->create()->getCollection()
                                ->addFieldToSelect(['show_products'])
                                ->addFieldToFilter('rule_id', ['eq' => $ruleId]);
    }

    public function saveRuleProductsBulkIds($ruleId, $selectedProducts, $showProducts)
    {
        $this->autoRelatedListResourceModel->create()
             ->saveRuleProductsBulkIds(
                $ruleId,
                $selectedProducts,
                $showProducts
            );
    }
}
