<?php

namespace Extendware\AutoRelatedProducts\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;

class BlockPositions implements OptionSourceInterface
{
    public const POSITION_1 = 'position_1';
    public const POSITION_2 = 'position_2';
    public const POSITION_3 = 'position_3';
    
    public function getOptionArray()
    {
        $options = [];
        $options[self::POSITION_1] = __('Position 1');
        $options[self::POSITION_2] = __('Position 2');
        $options[self::POSITION_3] = __('Position 3');
        return $options;
    }

    public function getAllOptions()
    {
        $res = $this->getOptions();
        array_unshift($res, ['value' => '', 'label' => '']);
        return $res;
    }

    public function getOptions()
    {
        $res = [];
        foreach ($this->getOptionArray() as $index => $value) {
            $res[] = ['value' => $index, 'label' => $value];
        }
        return $res;
    }

    public function toOptionArray()
    {
        return $this->getOptions();
    }
}
