<?php

namespace Extendware\AutoRelatedProducts\Model;

use Extendware\AutoRelatedProducts\Model\ResourceModel\AutoRelated\CollectionFactory;

class DataProvider extends \Magento\Ui\DataProvider\AbstractDataProvider
{
    protected $loadedData;

    // @codingStandardsIgnoreStart
    public function __construct(
        $name,
        $primaryFieldName,
        $requestFieldName,
        CollectionFactory $autoRelatedCollectionFactory,
        array $meta = [],
        array $data = []
    ) {
        $this->collection = $autoRelatedCollectionFactory->create();
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }
    // @codingStandardsIgnoreEnd

    public function getData()
    {
        if (isset($this->loadedData)) {
            return $this->loadedData;
        }
        $items = $this->collection->getItems();
        foreach ($items as $autoRelated) {
            $this->loadedData[$autoRelated->getId()] = $autoRelated->getData();
        }
        return $this->loadedData;
    }
}
