<?php
namespace Extendware\AutoRelatedProducts\Model\Indexer;

use Magento\Framework\Indexer\ActionInterface as IndexerActionInterface;
use Magento\Framework\Mview\ActionInterface as MviewActionInterface;
use Psr\Log\LoggerInterface as Logger;
use Extendware\AutoRelatedProducts\Model\AutoRelatedProductManager;

class AutoRelatedProduct implements IndexerActionInterface, MviewActionInterface
{
   /**
     * @var AutoRelatedProductManager
     */
    protected $autoRelatedProductManager;

    /**
     * @var Logger
     */
    protected $logger;

    /**
     * Constructor.
     *
     * @param Logger $logger
     */
    public function __construct(
        AutoRelatedProductManager $autoRelatedProductManager,
        Logger $logger
    ) {
        $this->autoRelatedProductManager = $autoRelatedProductManager;
        $this->logger = $logger;
    }

    /**
     * It's used by mview. It will execute when process indexer in "Update on schedule" Mode.
     * Used by mview, allows process indexer in the "Update on schedule" mode
     */
    public function execute($ids)
    {
        $this->autoRelatedProductManager->processAll($ids);
    }

    /**
     * Add code here for execute full indexation
     * Will take all of the data and reindex
     * Will run when reindex via command line
     */
    public function executeFull()
    {
        $this->autoRelatedProductManager->processAll();
    }

    /**
     * Add code here for execute partial indexation by ID list
     * Works with a set of entity changed (may be massaction)
     */
    public function executeList(array $ids)
    {
        $this->autoRelatedProductManager->processAll($ids);
    }

    /**
     * Add code here for execute partial indexation by ID
     * Works in runtime for a single entity using plugins
     */
    public function executeRow($id)
    {
        $this->autoRelatedProductManager->processAll([$id]);
    }
}
