<?php

namespace Extendware\AutoRelatedProducts\Model\ResourceModel;

use Magento\Framework\Model\ResourceModel\Db\AbstractDb;

class AutoRelatedList extends AbstractDb
{
    public const CHUNK_SIZE = 500;

    protected function _construct()
    {
        $this->_init('extendware_auto_related_products_list', 'id');
    }

    public function truncateTable()
    {
        if ($this->getConnection()->getTransactionLevel() > 0) {
            $this->getConnection()->delete($this->getMainTable());
        } else {
            $this->getConnection()->truncateTable($this->getMainTable());
        }

        return $this;
    }

    public function saveRuleProductsBulkIds($ruleId, $selectedProducts, $showProducts)
    {
        $connection = $this->getConnection();
        $tableName = $this->getMainTable();

        try {
            // Delete existing for rule
            $connection->delete($tableName, ['rule_id = ?' => $ruleId]);

            // Prepare bulk insert data
            $count = max(count($selectedProducts), count($showProducts));
            $insertData = [];

            for ($i = 0; $i < $count; $i++) {
                $insertData[] = [
                    'rule_id' => $ruleId,
                    'selected_product' => $selectedProducts[$i] ?? null,
                    'show_products' => $showProducts[$i] ?? null,
                ];
            }

            // Insert in chunks for large dataset
            $connection->beginTransaction();
            try {
                foreach (array_chunk($insertData, self::CHUNK_SIZE) as $chunk) {
                    $connection->insertMultiple($tableName, $chunk);
                }
                $connection->commit();
            } catch (\Exception $e) {
                $connection->rollBack();
                throw $e;
            }
        } catch (\Exception $e) {
            $connection->rollBack();
            throw $e;
        }

        return true;
    }
}
