<?php
/*
 *
 *  *
 *  *  * web-vision GmbH
 *  *  * Do not edit or add to this file if you wish to upgrade Magento to newer
 *  *  * versions in the future. If you wish to customize Magento for your
 *  *  * needs please refer to https://www.web-vision.de for more information.
 *  *  * @copyright   Copyright (c) 2001-2025 web-vision GmbH (https://www.web-vision.de)
 *  *  * @author      Parth Trivedi
 *  *
 *
 */
declare(strict_types=1);

namespace Extendware\AutoRelatedProducts\ViewModel\Product\Listing;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\App\ActionInterface;
use Magento\Framework\Url\Helper\Data as UrlHelper;
use Extendware\AutoRelatedProducts\Helper\Data as AutoRelatedProductsHelper;
use Magento\Catalog\Model\ResourceModel\Product\Attribute\CollectionFactory as AttributeCollectionFactory;

/**
 * Check is available add to compare.
 */
class PreparePostData implements ArgumentInterface
{
    /**
     * Base template path for components
     */
    private const BASE_TEMPLATE_PATH = 'Extendware_AutoRelatedProducts::product/list/items/';

    /**
     * @var UrlHelper
     */
    private $urlHelper;

    /**
     * @var AutoRelatedProductsHelper
     */
    private $autoRelatedProductsHelper;

    /**
     * @var \Magento\Framework\View\LayoutInterface
     */
    protected $layout;

    /**
     * @var AttributeCollectionFactory
     */
    private $attributeCollectionFactory;

    /**
     * @param UrlHelper $urlHelper
     * @param AutoRelatedProductsHelper $autoRelatedProductsHelper
     * @param \Magento\Framework\View\LayoutInterface $layout
     * @param AttributeCollectionFactory $attributeCollectionFactory
     */
    public function __construct(
        UrlHelper $urlHelper,
        AutoRelatedProductsHelper $autoRelatedProductsHelper,
        \Magento\Framework\View\LayoutInterface $layout,
        AttributeCollectionFactory $attributeCollectionFactory
    ) {
        $this->urlHelper = $urlHelper;
        $this->autoRelatedProductsHelper = $autoRelatedProductsHelper;
        $this->layout = $layout;
        $this->attributeCollectionFactory = $attributeCollectionFactory;
    }

    /**
     * Wrapper for the PostHelper::getPostData()
     *
     * @param string $url
     * @param array $data
     * @return array
     */
    public function getPostData(string $url, array $data = []):array
    {
        if (!isset($data[ActionInterface::PARAM_NAME_URL_ENCODED])) {
            $data[ActionInterface::PARAM_NAME_URL_ENCODED] = $this->urlHelper->getEncodedUrl();
        }
        return ['action' => $url, 'data' => $data];
    }

    public function AutoRelatedProductsHelper()
    {
        return $this->autoRelatedProductsHelper;
    }

    /**
     * Get sortable attributes collection
     *
     * @return \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection
     */
    public function getSortableAttributes()
    {
        $collection = $this->attributeCollectionFactory->create();
        $collection->addFieldToFilter('used_for_sort_by', 1)
            ->addFieldToFilter('is_visible', 1)
            ->setOrder('frontend_label', 'ASC');

        return $collection;
    }

    /**
     * Get HTML for a component block
     *
     * @param string $type Type of component (sorter, limiter, pagination, loader, success-popup)
     * @param int    $ruleId
     * @return string
     */
    public function getComponentHtml(string $type, $ruleId = 0)
    {
        $block = $this->layout->createBlock(\Magento\Framework\View\Element\Template::class)
            ->setTemplate(self::BASE_TEMPLATE_PATH . $type . '.phtml');

        if ($ruleId !== 0) {
            $block->setData('rule_id', $ruleId);
        }

        if ($type === 'sorter') {
            $block->setData('sortable_attributes', $this->getSortableAttributes());
        }

        return $block->toHtml();
    }
}
