<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

namespace Extendware\Bfcache\Block;

use Magento\Framework\View\Element\Template;
use Extendware\Bfcache\Helper\Data as Helper;

class CartUpdate extends Template
{
    /**
     * @var Helper
     */
    protected Helper $helper;

    /**
     * @param Helper $helper
     * @param Template\Context $context
     * @param array $data
     */
    public function __construct(
        Helper           $helper,
        Template\Context $context,
        array            $data = []
    )
    {
        $this->helper = $helper;
        parent::__construct($context, $data);
    }

    /**
     * Check if the cart should be updated after interaction.
     *
     * @return bool|null
     */
    public function updateCartOnInteract()
    {
        return $this->helper->miniCartUpdateAfterInteraction();
    }

    /**
     * Get the delay for displaying content.
     *
     * @return string|null
     */
    public function displayOnDelay()
    {
        return $this->helper->getCustomDelay();
    }

    /**
     * Retrieve the preload intensity setting.
     *
     * @return string|null
     */
    public function getPreloadIntensity()
    {
        return $this->helper->getPreloadIntensity();
    }

    /**
     * Retrieve the URLs in the preload blacklist.
     *
     * @return array|null
     */
    public function getBlacklistUrl()
    {
        return $this->helper->getBlacklistUrl();
    }

    /**
     *
     */
    public function isPagePreloadEnabled()
    {
        return $this->helper->isPagePreloadEnabled();
    }
}
