<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

namespace Extendware\Bfcache\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Extendware\Bfcache\Helper\Data as Helper;

class ConfigData implements ConfigProviderInterface
{
    /**
     * @var Helper
     */
    protected $helper;

    /**
     * @param Helper $helper
     */
    public function __construct(
        Helper $helper
    )
    {
        $this->helper = $helper;
    }

    /**
     * @return array
     */
    public function getConfig()
    {
        $config = [];
        $config['cartconfig'] = $this->helper->miniCartUpdateAfterInteraction();

        return $config;
    }
}
