<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

namespace Extendware\Bfcache\Plugin;

use Magento\Framework\App\Request\Http as HttpRequest;
use Magento\Framework\App\Response\Http;
use Extendware\Bfcache\Helper\Data;

class CacheControl
{
    /**
     * @var HttpRequest
     */
    protected $request;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @param Data $helper
     * @param HttpRequest $request
     */
    public function __construct(
        Data        $helper,
        HttpRequest $request
    )
    {
        $this->helper = $helper;
        $this->request = $request;
    }

    /**
     * Alter headers for no-cache responses
     *
     * @return void
     */
    public function aroundSetNoCacheHeaders(Http $subject, \Closure $proceed)
    {
        if (!$this->helper->isModuleRegistered()) {
            $proceed();
        }

        $isBfCacheEnabled = $this->helper->isBfCacheEnabled();
        $pagePreloadEnabled = $this->helper->isPagePreloadEnabled();
        $maxAge = $this->helper->getHeaderMaxAge();

        if ($isBfCacheEnabled) {
            $excludedRoute = false;
            if (!$this->request->isAjax()) {
                $uriPath = $this->request->getUri()->getPath();
                foreach ($this->helper->excludedRoutes() as $route) {
                    if (str_contains($uriPath, $route)) {
                        $excludedRoute = true;
                        break;
                    }
                }
            }
            if (!$excludedRoute || ($pagePreloadEnabled && $maxAge)) {
                $subject->setHeader('cache-control', 'public, max-age=' . ($maxAge ?? 5), true);
                $subject->setHeader('permissions-policy', 'unload=()', true);
                return;
            }
        }

        $proceed();
    }
}
