# Back/Forward Cache Extension for Magento 2

Extendware Back/Forward Cache makes browsing faster by using the browser's back-forward cache feature. It stores pages in the browser, helping users move swiftly between pages they've already seen.

## Interested in Extension Installation?

**Interested in Extension Installation?**

Visit our installation service page [https://www.extendware.com/magento-extension-installation-service.html](https://www.extendware.com/magento-extension-installation-service.html) for more information

Got questions? Feel free to contact us! [Support Form](https://support.extendware.com/).


## User Guide

We highly recommend gathering all the below information, before starting the installation.

### Prerequisites
Make sure the cron is configured and running. You can find the details from here: [Configure and run cron](https://devdocs.magento.com/guides/v2.3/config-guide/cli/config-cli-subcommands-cron.html)

### Installation Procedure
- Download your extension package from the [Download](https://www.extendware.com/downloadable/customer/products/) page after purchasing the extension.

- Open the extension ZIP file you downloaded and extract it to a directory on your computer using a tool like WinRar, WinZIP or similar.

- Upload the extracted folders and files into the root directory of your Magento installation. The root directory of Magento is the folder that contains the directories "app", "bin", "lib" and more. All folders should match the existing folder structure. If one of our extensions is already installed and you're updating it, make sure to overwrite the existing files of the extension.

- Connect via SSH and run the following commands (make sure to run them as the user who owns the Magento files!

    ```
    php bin/magento module:enable --clear-static-content Extendware_Core
    
    php bin/magento module:enable --clear-static-content Extendware_Bfcache
    
    php bin/magento maintenance:enable
    
    php bin/magento setup:upgrade
    
    php bin/magento setup:di:compile
    
    php bin/magento setup:static-content:deploy
    
    php bin/magento maintenance:disable
    ```

- In case if you still do not see the extension active, Go to Admin -> System -> Cache Management and click both the 'Flush Magento Cache' as well as the 'Flush Cache Storage' button.
- Woo-ha! You have successfully installed the extension and your store is ready to protect from spammers and bad bots.

### Configuration

To configure the extension you need to go to Dashboard → Stores → Configuration → Extendware Menu**.

![config_page](docs/images/ew-config.png)

### Configuration Overview for Back/Forward Cache

**Module Enable** - Select Yes to enable the module.

**Update Mini Cart Upon User Interaction > Enable** - When the page reloads from bfcache, the Mini Cart will either update immediately or wait until the user interacts with the page before updating.

**Exclude Pages from Caching** - List the names of pages/route that should not be stored in the bfcache. Use comma-separated values.

### Configuration Overview for Page Preload

**Module Enable** - Select Yes to enable the module.

**Link Preload Setting On Hover** - Select a delay (in milliseconds) for how long the user needs to hover the mouse over a link before the page starts preloading. The default delay time is 65 you can add custom delay by choosing 'Custom Delay'

**Preload Cache Control Max-Age** - Set how long preloaded content stays in the browser (e.g., "300" seconds).

**BlackList Url'\s** - List the names of the pages that should be blacklisted. Make sure to add comma-separated value.

![system_config](docs/images/system_config.png)

### Frontend View
Once the extension is configured for testing Chrome DevTools can assist you in testing your pages to ensure they're optimized for bfcache.

For testing:

* Go to the page in Chrome. 
* Open DevTools and navigate to Application > Back-forward Cache. 
* Click the "Run Test" button. DevTools will attempt to navigate away from the page and then back to determine if the page can be restored from the bfcache.

![before-bfcache](docs/images/before-bfcache.png)

![after-bfcache-bfcache](docs/images/after-bfcache.png)

## Changelog
All notable changes to this project will be documented here.

## [1.0.2]
#### Added
- Add support to Enable/Disable Page Preload configuration.

## [1.0.1]
#### Added
- Support with Hyvä theme compatibility.

### [1.0.0]
#### Added
- Initial release
