<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Controller\Adminhtml;

use Extendware\ContactUsTracker\Model\Repository;
use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs as ContactUsResource;
use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\Page;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\View\Result\PageFactory;
use Psr\Log\LoggerInterface;
use Extendware\ContactUsTracker\Model\ResourceModel\ContactUs\CollectionFactory;

abstract class ContactUsTracker extends Action
{
    protected $collectionFactory;

    public function __construct(
        protected PageFactory $resultPageFactory,
        protected Repository $repository,
        protected ContactUsResource $resource,
        protected LoggerInterface $logger,
        CollectionFactory $collectionFactory,
        Context $context
    ) {
        parent::__construct($context);
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * Create result page
     */
    protected function createResultPage(): Page
    {
        /** @var Page $resultPage */
        $resultPage = $this->resultPageFactory->create();
        $resultPage->setActiveMenu('Extendware_ContactUsTracker::contact_us_list');
        $resultPage->getConfig()->getTitle()->prepend(__('Contact Us Tracker'));

        return $resultPage;
    }

    /**
     * Get id from request
     */
    protected function getId(): int
    {
        return (int) $this->getRequest()->getParam('id');
    }

    /**
     * Get grid redirect
     */
    protected function getGridRedirect(): Redirect
    {
        $redirect = $this->resultRedirectFactory->create();
        $redirect->setPath('contact_us/tracker/index');

        return $redirect;
    }

    /**
     * Get view redirect
     */
    protected function getViewRedirect(): Redirect
    {
        $redirect = $this->resultRedirectFactory->create();
        $redirect->setPath(
            'contact_us/tracker/view',
            ['id' => $this->getId()]
        );

        return $redirect;
    }
}
