<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Controller\Adminhtml\Tracker;

use Exception;
use Extendware\ContactUsTracker\Controller\Adminhtml\ContactUsTracker;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\Result\Redirect;

class Delete extends ContactUsTracker implements HttpPostActionInterface
{
    /**
     * Delete contact us record
     */
    public function execute(): Redirect
    {
        try {
            $this->repository->deleteById($this->getId());
            $this->messageManager->addSuccessMessage(__('Record has been successfully deleted'));
            return $this->getGridRedirect();
        } catch (Exception $e) {
            $this->logger->critical($e);
            $this->messageManager->addErrorMessage($e->getMessage());
        }

        return $this->getViewRedirect();
    }
}
