<?php
/*
 web-vision GmbH
 Do not edit or add to this file if you wish to upgrade Magento to newer
 versions in the future. If you wish to customize Magento for your
 needs please refer to https://www.web-vision.de for more information.
 @category    Extendware
 @copyright   Copyright (c) 2001-2023 web-vision GmbH (https://www.web-vision.de)
 @author      Bushra Asif <ba@web-vision.de>
*/

declare(strict_types=1);

namespace Extendware\ContactUsTracker\Controller\Adminhtml\Tracker;

use Exception;
use Extendware\ContactUsTracker\Controller\Adminhtml\ContactUsTracker;
use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\Controller\Result\Redirect;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Exception\LocalizedException;

class MassDelete extends ContactUsTracker implements HttpPostActionInterface
{
    public function execute(): Redirect
    {
        $selected = $this->getRequest()->getParam('selected', []);
        $excluded = $this->getRequest()->getParam('excluded', []);

        try {
            if (empty($selected) && $excluded === 'false') {
                // Select all logic
                $collection = $this->collectionFactory->create();
                $ids = $collection->getAllIds();
            } elseif (!empty($selected)) {
                // Only selected IDs
                $ids = $selected;
            } else {
                $ids = [];
            }

            if (!empty($ids)) {
                $this->resource->massDelete($ids);
                $this->messageManager->addSuccessMessage(__('Records have been successfully deleted.'));
            } else {
                $this->messageManager->addErrorMessage(__('No records selected for deletion.'));
            }
        } catch (Exception $e) {
            $this->logger->critical($e);
            $this->messageManager->addErrorMessage(__('Something went wrong while deleting the records.'));
        }

        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('*/*/index');
    }
}
